# PowerShell GUI-App: OpenDNS FamilyShield ein-/ausschalten
# Hinweis: Mit Adminrechten starten!

[Console]::OutputEncoding = [System.Text.Encoding]::UTF8

# --- Fenstergröße setzen (Breite/Höhe in Zeichen) ---
$Host.UI.RawUI.WindowSize = New-Object Management.Automation.Host.Size(50,20)

# --- Admin-Prüfung ---
if (-not ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole] "Administrator")) {
    Add-Type -AssemblyName System.Windows.Forms
    [System.Windows.Forms.MessageBox]::Show("❌ Bitte PowerShell als Administrator starten!`nDieses Skript benötigt erhöhte Rechte.", "Adminrechte fehlen", 'OK', 'Error')
    exit
}

Add-Type -AssemblyName System.Windows.Forms
Add-Type -AssemblyName System.Drawing

# DNS-Server (OpenDNS FamilyShield)
$openDNS = @("208.67.222.123","208.67.220.123")

function Set-DNS {
    param([string[]]$Servers)
    try {
        # Nur gezielt WLAN und Ethernet setzen
        $targets = @("WLAN","Ethernet")
        foreach ($alias in $targets) {
            if ($Servers -and $Servers.Count -gt 0) {
                Set-DnsClientServerAddress -InterfaceAlias $alias -ServerAddresses $Servers -ErrorAction Stop
            } else {
                Set-DnsClientServerAddress -InterfaceAlias $alias -ResetServerAddresses -ErrorAction Stop
            }
        }
        return $true
    } catch {
        [System.Windows.Forms.MessageBox]::Show("Fehler: " + $_.Exception.Message, "DNS-Fehler", 'OK', 'Error')
        return $false
    }
}

function Show-Status {
    $status = Get-DnsClientServerAddress | Where-Object { $_.InterfaceAlias -in @("WLAN","Ethernet") }
    $lines = foreach ($adapter in $status) {
        "Adapter: $($adapter.InterfaceAlias) → DNS: $($adapter.ServerAddresses -join ', ')"
    }
    if (-not $lines) { return "Keine statischen DNS-Server gesetzt (DHCP/Auto)." }
    return ($lines -join "`n")
}

# Fenster erstellen (Breite +100 px)
$form = New-Object System.Windows.Forms.Form
$form.Text = "OpenDNS Umschalter"
$form.Size = New-Object System.Drawing.Size(520,210)   # vorher 420 → jetzt 520
$form.StartPosition = "CenterScreen"
$form.Topmost = $true

# Statuslabel im Fenster
$lbl = New-Object System.Windows.Forms.Label
$lbl.AutoSize = $true
$lbl.Location = New-Object System.Drawing.Point(20,110)
$lbl.Font = New-Object System.Drawing.Font("Segoe UI",9)
$lbl.Text = "Status: $(Show-Status)"
$form.Controls.Add($lbl)

# Button OpenDNS EIN
$btnOn = New-Object System.Windows.Forms.Button
$btnOn.Text = "OpenDNS EIN"
$btnOn.Location = New-Object System.Drawing.Point(50,40)
$btnOn.Size = New-Object System.Drawing.Size(140,40)
$btnOn.Add_Click({
    if (Set-DNS -Servers $openDNS) {
        $msg = "OpenDNS FamilyShield aktiviert!`n`n$(Show-Status)"
        [System.Windows.Forms.MessageBox]::Show($msg, "Erfolg", 'OK', 'Information')
        $lbl.Text = "Status: $(Show-Status)"
    }
})

# Button OpenDNS AUS
$btnOff = New-Object System.Windows.Forms.Button
$btnOff.Text = "OpenDNS AUS"
$btnOff.Location = New-Object System.Drawing.Point(220,40)
$btnOff.Size = New-Object System.Drawing.Size(140,40)
$btnOff.Add_Click({
    if (Set-DNS -Servers @()) {
        $msg = "Standard-DNS (DHCP/Auto) wiederhergestellt!`n`n$(Show-Status)"
        [System.Windows.Forms.MessageBox]::Show($msg, "Erfolg", 'OK', 'Information')
        $lbl.Text = "Status: $(Show-Status)"
    }
})

# Buttons hinzufügen
$form.Controls.Add($btnOn)
$form.Controls.Add($btnOff)

# Fenster anzeigen
$form.ShowDialog()